/************************************************************************
* (c) Copyright Freescale Semiconductor, Inc 2010, All Rights Reserved  *
*************************************************************************

************************************************************************
*                                                                      *
*        Standard Software Flash Driver For FTFL           		         *
*                                                                      *
* FILE NAME     :  SetEEEEnable.c                                      *
* DATE          :  June 11,2010                                        *
*                                                                      *
* AUTHOR        :  FPT Team                                            *
* E-mail        :  b28216@freescale.com                                *
*                                                                      *
************************************************************************/

/************************** CHANGES ***********************************
0.0.1    	06.09.2010    	FPT Team            		Initial Version
0.1.0    	06.11.2010    	FPT Team            		Finalize to 0.1.0 
***********************************************************************/

/* include the header files */
#include "SSD_Types.h"
#include "SSD_FTFL.h"
#include "SSD_FTFL_Internal.h"


/************************************************************************
*
*  Function Name    : SetEEEEnable.c
*  Description      : This function is used to change the function of 
*					            the EERAM. When not partitioned for EEE, the EERAM 
*					            is typically used as traditional RAM. When partitioned 
*					            for EEE, the EERAM is typically used to store EEE data.
*  Arguments        : PFLASH_SSD_CONFIG, UINT8
*  Return Value     : UINT32
*
*************************************************************************/

UINT32 SetEEEEnable(PFLASH_SSD_CONFIG PSSDConfig, UINT8 EEEEnable)
{
  UINT8 pCommandArray[2]; /* command sequence array */
  UINT32 returnCode;      /* return code variable */

  /* set the default return code as FTFL_OK */
  returnCode = FTFL_OK;
	
	/* preparing passing parameter to set EEPROM Enabled command */
  pCommandArray[0] = FTFL_SET_EERAM;
	pCommandArray[1] = EEEEnable;

  /* calling flash command sequence function to execute the command */
  returnCode = FlashCommandSequence(PSSDConfig, 1, pCommandArray);

    /* Enter Debug state if enabled */
    if (TRUE == (PSSDConfig->DebugEnable))
    {
         asm
         (
          debughlt           /* enter Debug state */
         );
    }

    return(returnCode);
}
/* end of file */